;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;								;
; 	Copyright 2013, 2014 Fidelity Information Services, Inc	;
; 								;
; 	This source code contains the intellectual property	;
; 	of its copyright holder(s), and is made available	;
; 	under a license.  If you do not know the terms of	;
; 	the license, please stop and do not read further.	;
;	    	     	    	     	    	 		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Gleaner routines for PipeLine region/replication info extraction
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Function driven at the beginning of each data gathering cycle (occurs every pipeCycle or PipeCmd arg seconds). All Exprs have an arg of input
; data but Pre and Post exprs get a NULL argument from PipeLine().
;
PreExpr(%l)
	New pccycle
	;
	; Verify arguments for pipeCmd. Must have one of:
	;
	;   1. Pipe cycle is -1 (non-repeating) and last token of pipeCmd is a positive integer specifying the seconds
	;      to sleep between data fetches (pipeCmd stays running).
	;   2. Pipe cycle is a positive integer specifying the time between data fetches and the pipeCmd argument is -1
	;      indicating it doesn't sleep but terminates after each data fetch cycle.
	;
	; Note uses pipeCmd and pipeCycle set by PipeLine.m argument processing.
	;
	; Do doWrite^InfoHubUtils("Entering PreExpr^"_$Text(+0))				;##
	Set pccycle=$ZPiece(pipeCmd," ",$ZLength(pipeCmd," "))	; pipeCmd cycle argument
	Do:(+pccycle'=pccycle) IHError^InfoHubError("IHGLNRERR",,,,"Invalid pipeCmd cycle parameter - must be numeric")
	Do:((0>pccycle)&(0>pipeCycle)) IHError^InfoHubError("IHGLNRERR",,,,"One of PipeLine cycle or Pipecmd cycle parameter must be greater than 0")
	Do:((-1'=pccycle)&(-1'=pipeCycle)) IHError^InfoHubError("IHGLNRERR",,,,"One of PipeLine cycle or Pipecmd cycle parameter must be -1")
	Quit ""

;
; Stub InfoExpr gleaner function. Accepts an argument usually read from the PipeCmd output. Purpose of this routine can be to reformat this record
; in cases where that is necessary but the currently supplied PipeCmds takes care of all that formatting.
;
InfoExpr(%l)
	; Do doWrite^InfoHubUtils("Entering InfoExpr^"_$Text(+0)_" for key-value: "_%l)		;##
	Quit %l

;
; Stub PostExpr gleaner function. Like PreExpr, PipeLine calls us with a NULL argument currently.
;
PostExpr(%l)
	; Do doWrite^InfoHubUtils("Entering PostExpr^"_$Text(+0))				;##
	Quit ""

;
; PreExpr for stderr processing. Setup the key to be used for pushing out errors
;
PreExprStdErr(%l)
	; Do doWrite^InfoHubUtils("Entering PreExprStdErr^"_$Text(+0))				;##
	Set StdErrKey=9897
	Quit ""

;
; InfoExpr for stderr processing. Does nothing at this time but can be expanded to deal with (i.e. log) errors returned from the
; pipe command.
;
InfoExprStdErr(%l)
	; Do doWrite^InfoHubUtils("Entering InfoExprStdErr^"_$Text(+0)_" for key-value: "_%l)	;##
	Quit StdErrKey_pieceSeparator_%l

;
; PostExpr for stderr processing. Only used for debugging purposes.
;
PostExprStdErr(%l)
	; Do doWrite^InfoHubUtils("Entering PostExprStdErr^"_$Text(+0))				;##
	Quit ""
