;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;								;
; 	Copyright 2014 Fidelity Information Services, Inc	;
; 								;
; 	This source code contains the intellectual property	;
; 	of its copyright holder(s), and is made available	;
; 	under a license.  If you do not know the terms of	;
; 	the license, please stop and do not read further.	;
;	    	     	    	     	    	 		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	;gtmDBConfGenerator
	;
	set zver=$zversion
	set defaultGTMVersion=$piece(zver," ",1,2)
	set defaultPlatform=$piece(zver," ",3,4)
	set defaultselection=0
	do initPlatformsandGTMVersions() ; fills in Platforms and GTMVersions
	;
	; Get publisher name, platform type and GT.M version
	; 	
	set maxtries=3
	set trynum=1
	for  quit:trynum>maxtries  do
	. write "Enter publisher name (default:db1)",!
	. read pubname
	. if ((pubname'="")&'(pubname?1(1A,1"%").31(1A,1N))),$increment(trynum) write !,"Please enter a valid publisher name",!
	. else  set trynum=maxtries+1
	if ((pubname'="")&'(pubname?1(1A,1"%").31(1A,1N))) quit
	if pubname="" set pubname="db1"
	write !!
	write "Select a Platform:",!
	set trynum=1
	set defaultselection=0
	for  quit:trynum>maxtries  do
	. for i=1:1:Platform(0) set plat=$piece(Platform(i),"|",1) write i_" : "_plat,! if plat=defaultPlatform set defaultselection=i
	. write "Please enter number "_$select(defaultselection:"(default:"_defaultselection_")",1:"")_":",!
	. read num
	. if (num="")&(defaultselection>0) set num=defaultselection
	. if ((num<1)!(num>Platform(0))),$increment(trynum) write !,"Please enter a number between 1 and "_Platform(0),!
	. else  set trynum=maxtries+1
	if ((num<1)!(num>Platform(0))) quit
	set ptype=$piece(Platform(num),"|",2) 
	write !!
	write "Select a GT.M version:",!
	set trynum=1
	set defaultselection=0
	for  quit:trynum>maxtries  do
	. for i=1:1:GTMVersion(0) set vers=$piece(GTMVersion(i),"|",1) write i_" : "_vers,! if vers=defaultGTMVersion set defaultselection=i
	. write "Please enter number "_$select(defaultselection:"(default:"_defaultselection_")",1:"")_":",!
	. read num
	. if (num="")&(defaultselection>0) set num=defaultselection
	. if ((num<1)!(num>GTMVersion(0))),$increment(trynum) write !,"Please enter a number between 1 and "_GTMVersion(0),!
	. else  set trynum=maxtries+1
	if ((num<1)!(num>GTMVersion(0))) quit
	write !
	set ptype=ptype_$piece(GTMVersion(num),"|",2) 
	;
	; create the configuration file
	;
	set out=pubname_".conf"
	open out:newversion
	use out
	write "Publisher:DBInstances:"_pubname_":::infogleaner:1000:1000",!
	write "// create Env descriptors for InfoHub",!
	set gbldir=$ztrnlnm("gtmgbldir")
	set:($extract(gbldir,1)'="/") gbldir=$zparse(gbldir)  
	write "Env:","gtmgbldir","='",gbldir,"'",!
	for env="gtm_dist","gtmroutines","gtm_tmp","gtm_repl_instance" do
	. write "Env:",env,"='",$ztrnlnm(env),"'",!
	write "//Env:<env var used in the gld>",!
	write "//Env:IHCD=<path to start of relative paths in global directory>",!
	write "PipeLine:RegReplData:RegReplFetch::"_pubname_":$gtm_dist/mumps -run Init^IHRRPCmd"_ptype_" 30:-1:2:$char(30):PreExpr^PipeLineRRGleaner:InfoExpr^PipeLineRRGleaner:",!
	write "PipeLine:RegReplData:CritDetection::"_pubname_":$gtm_dist/mumps -run Init^IHCDPCmd"_ptype_" 10:-1:2:$char(30)::InfoExpr^PipeLineRRGleaner:",!
	close out
	write "Publisher: TempPWD=infogleaner TempDBAllocate=1000, TempDBExtend=1000",!
	write "PipeLine RegReplFetch: PipeCmd option=30 PipeCycle=-1 (do not restart) Timeout=2 PieceSeparator=$char(30)",!
	write "PipeLine CritDetection: PipeCmd option=10 PipeCycle=-1 (do not restart) Timeout=2 PieceSeparator=$char(30)",!
	write "Please ensure that Env:gtmroutines directive contains InfoHub's pipecmd directory.",!
	write "If any environment variables are used in the global directory please add Env: directives for them.",!
	write "If the global directory uses relative paths when referencing the database file(s) please add Env:IHCD=<path to start of relative paths>.",!
	write "Place "_pubname_".conf in the configs directory of the GT.M monitoring Reference Implementation.",!
	write "Place an Include directive in the Monitor Database section of server1.conf.",!
	write "Created "_pubname_".conf",!
	quit

initPlatformsandGTMVersions()
	;
	; Choices for Platform
	;
	set Platform(0)=5
	set Platform(1)="AIX RS6000|AIXOnPSeries"
	set Platform(2)="HP-UX IA64|HPUXOnIA64"
	set Platform(3)="Linux x86|LinuxOnX8632"
	set Platform(4)="Linux x86_64|LinuxOnX8664"
	set Platform(5)="Solaris SPARC|SolarisOnSPARC"
	;
	; Choices for GT.M Version
	;
	set GTMVersion(0)=3
	set GTMVersion(1)="GT.M V6.0-002|V60002"
	set GTMVersion(2)="GT.M V6.0-003|V60003"
	set GTMVersion(3)="GT.M V6.1-000|V61000"
	quit
